/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
/*
 * Subset of logging stuff in Linux layer
 *
 * $Id: Logger-gpl.h,v 1.5 2001/09/22 20:07:53 dcraft Exp $
 *
 * $Log: Logger-gpl.h,v $
 * Revision 1.5  2001/09/22 20:07:53  dcraft
 * Remove kiobufs from cxiKernelIODescriptor_t.  Use temporary
 * kiobufs for map/unmap.   Remove dead code and dead comments
 * in portability layer and update readmes and license.
 * Fix traceback to appear in mmfs.log file.
 *
 * Revision 1.4  2001/05/23 16:47:36  wyllie
 * Add xxxASSERTRC variants of xxxASSERT that print additional info.
 *
 * Revision 1.3  2001/04/10 21:10:27  wyllie
 * Use EXTERNC macro to simplify declarations that need to work on both C
 * and C++.
 *
 * Revision 1.2  2000/12/15 13:56:30  gjertsen
 * Clean up documentation.
 *
 * Revision 1.1  2000/11/06 19:56:06  gjertsen
 * Linux code cleanup. Add build safeguards.
 *
 */

#ifndef _h_logger_gpl
#define _h_logger_gpl


#include <Shark-gpl.h>

#ifdef NDEBUG
#define LOGASSERT(_ex)  NOOP
#define LOGASSERTRC(_ex, _rc, _rea, _tag)  NOOP
#else
#define LOGASSERT(_ex)                                           \
  if (!(_ex)) {                                                  \
    logAssertFailed (2, __FILE__, __LINE__, 0, 0, 0, 0, # _ex);  \
  } else NOOP
#define LOGASSERTRC(_ex, _rc, _rea, _tag)                        \
  if (!(_ex)) {                                                  \
    logAssertFailed (2, __FILE__, __LINE__,                      \
                     _rc, _rea, _tag, 0, # _ex);                 \
  } else NOOP
#endif

#ifdef DBGASSERTS
#define DBGASSERT(_ex)  LOGASSERT(_ex)
#define DBGASSERTRC(_ex, _rc, _rea, _tag)  LOGASSERTRC(_ex, _rc, _rea, _tag)
#else  /* not DBGASSERTS */
#define DBGASSERT(_ex)  NOOP
#define DBGASSERTRC(_ex, _rc, _rea, _tag)  NOOP
#endif  /* DBGASSERTS */

/* predeclare logAssertFailed; instantiated in cxiSystem.C */
EXTERNC void logAssertFailed(
               UInt32 flags,         /* LOG_FATAL_ERROR or LOG_NONFATAL_ERROR */
               char  *srcFileName,   /* __FILE__ */
               UInt32 srcLineNumber, /* __LINE__ */
               Int32  retCode,       /* return code value */
               Int32  reasonCode,    /* normally errno */
               UInt32 logRecTag,     /* tag if have associated error log rec */
               char  *dataStr,       /* assert data string */
               char  *failingExpr);  /* expression that evaluated to false */

#endif /* _h_logger_gpl */
